/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl.visualization;

import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualManager;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.impl.visualization.storage.Storage;
import dev.engine_room.flywheel.impl.visualization.storage.Transaction;
import dev.engine_room.flywheel.lib.task.SimplePlan;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class VisualManagerImpl<T, S extends Storage<T>>
implements VisualManager<T> {
    private final Queue<Transaction<T>> queue = new ConcurrentLinkedQueue<Transaction<T>>();
    private final S storage;

    public VisualManagerImpl(S storage) {
        this.storage = storage;
    }

    public S getStorage() {
        return this.storage;
    }

    @Override
    public int visualCount() {
        return ((Storage)this.getStorage()).getAllVisuals().size();
    }

    @Override
    public void queueAdd(T obj) {
        if (!((Storage)this.getStorage()).willAccept(obj)) {
            return;
        }
        this.queue.add(Transaction.add(obj));
    }

    @Override
    public void queueRemove(T obj) {
        this.queue.add(Transaction.remove(obj));
    }

    @Override
    public void queueUpdate(T obj) {
        if (!((Storage)this.getStorage()).willAccept(obj)) {
            return;
        }
        this.queue.add(Transaction.update(obj));
    }

    public void processQueue(VisualizationContext visualizationContext, float partialTick) {
        Transaction<T> transaction;
        S storage = this.getStorage();
        while ((transaction = this.queue.poll()) != null) {
            switch (transaction.action()) {
                case ADD: {
                    ((Storage)storage).add(visualizationContext, transaction.obj(), partialTick);
                    break;
                }
                case REMOVE: {
                    ((Storage)storage).remove(transaction.obj());
                    break;
                }
                case UPDATE: {
                    ((Storage)storage).update(transaction.obj(), partialTick);
                }
            }
        }
    }

    public Plan<DynamicVisual.Context> framePlan(VisualizationContext visualizationContext) {
        return SimplePlan.of(context -> this.processQueue(visualizationContext, context.partialTick())).then(((Storage)this.storage).framePlan());
    }

    public Plan<TickableVisual.Context> tickPlan(VisualizationContext visualizationContext) {
        return SimplePlan.of(context -> this.processQueue(visualizationContext, 1.0f)).then(((Storage)this.storage).tickPlan());
    }

    public void onLightUpdate(long section) {
        ((Storage)this.getStorage()).lightUpdatedVisuals().onLightUpdate(section);
    }

    public boolean areGpuLightSectionsDirty() {
        return ((Storage)this.getStorage()).shaderLightVisuals().isDirty();
    }

    public LongSet gpuLightSections() {
        return ((Storage)this.getStorage()).shaderLightVisuals().sections();
    }

    public void invalidate() {
        ((Storage)this.getStorage()).invalidate();
    }
}

